#
# This is a minimal Python script for demonstrating the usage of the Goodtime Time Tracking REST-API v2.1
#
import requests


def main():
    hello()
    token = login()
    secured_hello(token)
    get_timetypes(token)
    get_users(token)
    get_projects(token)
    get_projects_for_user(token)
    get_timeientries_for_user(token)
    timeitem_id = create_timeentry(token)
    delete_timeentry(token, timeitem_id)


def hello():
    my_response = requests.get("https://getgoodtime.com/goodtime-rs/api/hello/sayhello")
    print("hello: " + str(my_response.status_code))
    print(my_response.content.decode("utf-8"))


def login():
    url = "https://getgoodtime.com/goodtime-rs/api/login"
    # heads up! It is a bad practice to hardcode the credentials.
    credentials = {"loginemail": "admin@somedomain.com", "apipassword": "12345678"}
    my_response = requests.post(url, json=credentials)
    print("login: " + str(my_response.status_code))
    company_id = my_response.content.decode("utf-8")
    print("company_id: " + company_id)
    token = my_response.headers["Authorization"]
    print("token: " + token)
    return token


def secured_hello(token):
    url = "https://getgoodtime.com/goodtime-rs/api/hello/securedSayhello"
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("secured_hello: " + str(my_response.status_code))
    print(my_response.content.decode("utf-8"))


def get_timetypes(token):
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/timetypes"
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("get_timetypes: " + str(my_response.content.decode("utf-8")))
    for timetype in my_response.json():
        print(timetype)


def get_users(token):
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/users"
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("get_users: " + str(my_response.content.decode("utf-8")))
    for user in my_response.json():
        print(user)


def get_projects(token):
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/projects"
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("get_projects: " + str(my_response.content.decode("utf-8")))
    for project in my_response.json():
        print(project)


def get_projects_for_user(token):
    useremail = "admin@somedomain.com"
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/projects/" + useremail
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("get_projects_for_user: " + str(my_response.content.decode("utf-8")))
    for project in my_response.json():
        print(project)


def get_timeientries_for_user(token):
    useremail = "admin@somedomain.com"
    start = "2020-01-01T00:00:00"
    end = "2020-01-07T23:59:00"
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/timeentries" \
          + "?useremail=" + useremail \
          + "&start=" + start \
          + "&end=" + end
    my_header = {'Authorization': token}
    my_response = requests.get(url, headers=my_header)
    print("get_timeientries_for_user: " + str(my_response.content.decode("utf-8")))
    for timeentry in my_response.json():
        print(timeentry)


def create_timeentry(token):
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/createtimeentry"
    param = {"useremail": "admin@somedomain.com",
             "starttime": "2022-12-30T10:24:00",
             "endtime": "2022-12-30T10:27:00",
             "timetypeid": "004c396a-9e24-411c-b6fd-9250a169b831",
             "projectid": "99f5012f-3ead-491c-ae91-28e3a2fe7407",
             "comment": "my comment"}

    my_header = {'Authorization': token}
    my_response = requests.post(url, json=param, headers=my_header)
    print("create_timeentry: " + my_response.content.decode("utf-8"))
    return my_response.content.decode("utf-8");


def delete_timeentry(token, timeitem_id):
    url = "https://getgoodtime.com/goodtime-rs/api/time-v2.1/deletetimeentry/" + timeitem_id
    my_header = {'Authorization': token}
    my_response = requests.delete(url, headers=my_header)
    print("delete_timeentry: " + str(my_response.status_code))


if __name__ == '__main__':
    main()
