package goodtime.rest.client;

import goodtime.rest.model.Timeentry;
import goodtime.rest.model.Timetype;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;

/**
 *
 * Created on 20.08.2023
 */
public class RestTimeClient {

    private String token;
    private String companyId;
    private static String createdTimeentryId;

    public static void main(String[] aArguments) {
        RestTimeClient rSTimeClient = new RestTimeClient();
        rSTimeClient.login();
        rSTimeClient.getTimetypes();
        rSTimeClient.getUsers();
        rSTimeClient.getProjects();
        rSTimeClient.getProjectsForUser();
        createdTimeentryId = rSTimeClient.createTimeentry();
        rSTimeClient.getTimeientriesForUser();
        rSTimeClient.deleteTimeentry(createdTimeentryId);
    }

    public void login() {
        Response response = null;
        try {
            // Credentials credentials = new Credentials("admin@someaccount.de", "123456");
            String credentialsString = "{ \"loginemail\": \"admin@someaccount.de\", \"apipassword\": \"12345678\" }";
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/login")
                    .request(MediaType.APPLICATION_JSON)
                    .post(Entity.entity(credentialsString, MediaType.APPLICATION_JSON));

            companyId = response.readEntity(String.class);
            System.out.println("id: " + companyId);
            token = response.getHeaderString(HttpHeaders.AUTHORIZATION);
            System.out.println("token: " + token);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void getTimetypes() {
        Response response = null;
        try { 
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("timetypes")
                    .request().accept(MediaType.APPLICATION_JSON)
                    .header(HttpHeaders.AUTHORIZATION, token).get(Response.class);
            System.out.println(response);
            // System.out.println(response.readEntity(String.class));

            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>() {
            };
            List<Timetype> timetypes = response.readEntity(genericType);
            System.out.println("Timetypes:");
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void getUsers() {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("users")
                    .request().accept(MediaType.APPLICATION_JSON)
                    .header(HttpHeaders.AUTHORIZATION, token).get(Response.class);
            System.out.println(response);
            // System.out.println(response.readEntity(String.class));

            GenericType<List<String>> genericType = new GenericType<List<String>>() {
            };
            List<String> loginEmailList = response.readEntity(genericType);
            System.out.println("Strings:");
            for (String loginemail : loginEmailList) {
                System.out.println("Loginemail: " + loginemail);
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void getProjects() {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("projects").request().accept(MediaType.APPLICATION_JSON)
                    .header(HttpHeaders.AUTHORIZATION, token).get(Response.class);
            System.out.println(response);
            // System.out.println(response.readEntity(String.class));

            System.out.println("Projects:");
            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>() {
            };
            List<Timetype> timetypes = response.readEntity(genericType);
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void getProjectsForUser() {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("projects").path("max@muster.com").request().accept(MediaType.APPLICATION_JSON)
                    .header(HttpHeaders.AUTHORIZATION, token).get(Response.class);
            System.out.println(response);
            // System.out.println(response.readEntity(String.class));

            System.out.println("Projects for user:");
            GenericType<List<Timetype>> genericType = new GenericType<List<Timetype>>() {
            };
            List<Timetype> timetypes = response.readEntity(genericType);
            for (Timetype timetype : timetypes) {
                System.out.println("Id: " + timetype.getId() + ", name: " + timetype.getName());
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
    
    public void getTimeientriesForUser() {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("timeentries")
                    .queryParam("useremail", "max@muster.com")
                    .queryParam("start", "2020-01-01T00:00:00") // we expect a String with format yyyy-MM-ddTHH:mm:00
                    .queryParam("end", "2020-01-07T23:59:00")
                    .request().accept(MediaType.TEXT_PLAIN)
                    .header(HttpHeaders.AUTHORIZATION, token).get(Response.class);
            System.out.println(response);
            GenericType<List<Timeentry>> genericType = new GenericType<List<Timeentry>>() {
            };
            List<Timeentry> timeentries = response.readEntity(genericType);
            System.out.println(timeentries.size() + " timeentries for user:");
            System.out.println("timeentries for user: " + timeentries);
            for (Timeentry timeentry : timeentries) {
                System.out.println(timeentry);
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public String createTimeentry() {
        Response response = null;
        try {
             Timeentry timeentry = new Timeentry();
            timeentry.setUseremail("admin@someaccount.de");
            // we expect a String with format 2007-12-03T10:15:30
            timeentry.setStarttime("2022-05-19T10:33:00");
            timeentry.setEndtime("2022-05-19T10:44:00");
            timeentry.setTimetypeid("4e63f61d-dafd-4775-b88d-31fda699cba1");
            timeentry.setProjectid("0137a6bf-ccdf-442f-a937-5642197276ea");
            timeentry.setComment("my comment");

            response = ClientBuilder.newClient()
                    .target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("createtimeentry")
                    .request()
                    .accept(MediaType.APPLICATION_JSON)
                    .header(HttpHeaders.AUTHORIZATION, token)
                    .post(Entity.entity(timeentry, MediaType.APPLICATION_JSON));
            System.out.println(response);
            if (response.getStatus() == 200) {
                GenericType<List<String>> genericType = new GenericType<List<String>>() {
                };
                List<String> idList = response.readEntity(genericType);
                for (String id : idList) {
                    System.out.println("cretated id: " + id);
                }
                return idList.get(0);
            }
        } finally {
            if (response != null) {
                response.close();
            }
        }
        return null;
    }
    
    public void deleteTimeentry(String timeentryId) {
        Response response = null;
        try {
            response = ClientBuilder.newClient().target("https://getgoodtime.com/goodtime-rs/api/time-v2.1")
                    .path("deletetimeentry")
                    .path(timeentryId)
                    .request().accept(MediaType.TEXT_PLAIN)
                    .header(HttpHeaders.AUTHORIZATION, token).delete(Response.class);
            System.out.println(response);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
}