import com.goodtimetracking.ws.punch.AuthenticationFault;
import com.goodtimetracking.ws.punch.OverlappingTimeEntryFault;
import com.goodtimetracking.ws.punch.PunchEntry;
import com.goodtimetracking.ws.punch.PunchWS;
import com.goodtimetracking.ws.punch.PunchWS_Service;
import com.goodtimetracking.ws.punch.ServiceFault;
import java.net.URL;
import javax.xml.ws.Service;

import java.net.MalformedURLException;
import javax.xml.namespace.QName;

/**
 * This is a simple test for the goodtime webservice.
 *
 * Files in package com.goodtimetracking.ws.punch have been created by the
 * java webservice import tool 'wsimport' automatically . wsimport can be found in
 * the java bin folder. 
 * To re-create these files just execute in the console:
 * (for Windows)    wsimport.exe -Xnocompile -d /set-here-local-path-for-the-produced-java-files -verbose https://www.goodtimetracking.com/goodtime-ws/PunchWS.wsdl 
 * (for Linux)      wsimport -Xnocompile -d /set-here-local-path-for-the-produced-java-files -verbose https://www.goodtimetracking.com/goodtime-ws/PunchWS.wsdl 
 */
public class TestPunchService {

    public static void main(String[] args) {
        new TestPunchService().testHello();
        new TestPunchService().testHello2();
        new TestPunchService().testGetLastPunchEntry();
        new TestPunchService().testPunch();
    }

    public void testHello() {
        try {
            System.out.println("testHello");
            Service service = Service.create(new URL("https://www.goodtimetracking.com/goodtime-ws/PunchWS.wsdl"), new QName("http://punch.ws.goodtimetracking.com/", "PunchWS"));
            PunchWS punchWs = service.getPort(PunchWS.class);
            String response = punchWs.hello();
            System.out.println("response: " + response);
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        } catch (ServiceFault ex) {
            ex.printStackTrace();
        }
    }

    public void testHello2() {
        System.out.println("testHello2");
        try {
            PunchWS_Service punchWS_Service = new PunchWS_Service();
            PunchWS punchWSPort = punchWS_Service.getPunchWSPort();
            punchWSPort.hello();
        } catch (ServiceFault ex) {
            ex.printStackTrace();
        }
    }

    public void testGetLastPunchEntry() {
        System.out.println("testGetLastPunchentry");
        try {
            PunchWS_Service punchWS_Service = new PunchWS_Service();
            PunchWS punchWSPort = punchWS_Service.getPunchWSPort();
            PunchEntry lastPunchentry = punchWSPort.getLastPunchEntry("someuser@just-a-test.de", "the-webservice-password");
            System.out.println(toLogString(lastPunchentry));
        } catch (AuthenticationFault ex) {
            ex.printStackTrace();
        } catch (ServiceFault ex) {
            ex.printStackTrace();
        }
    }

    public void testPunch() {
        System.out.println("testPunch");
        PunchWS_Service punchWS_Service = new PunchWS_Service();
        PunchWS punchWS = punchWS_Service.getPunchWSPort();
        PunchEntry lastPunchentry;
        try {
            lastPunchentry = punchWS.punch("someuser@just-a-test.de", "the-webservice-password");
            System.out.println(toLogString(lastPunchentry));
        } catch (AuthenticationFault ex) {
            ex.printStackTrace();
        } catch (OverlappingTimeEntryFault ex) {
            ex.printStackTrace();
        } catch (ServiceFault ex) {
            ex.printStackTrace();
        }
    }

    private String toLogString(PunchEntry punchEntry) {
        if (punchEntry == null) {
            return "punchEntry: Null";
        } else {
            String log = "punchEntry: ";
            log += "startTime: " + punchEntry.getStarttime();
            log += ", endTime: " + punchEntry.getEndtime();
            return log;
        }
    }

}
